﻿using System;

namespace Framework
{
    public static class Tuple
    {
        /// <summary>
        /// 2要素のタプルを生成します。
        /// </summary>
        public static Tuple<T1, T2> Create<T1, T2>(T1 t1, T2 t2)
        {
            return new Tuple<T1, T2>(t1, t2);
        }

        /// <summary>
        /// 3要素のタプルを生成します。
        /// </summary>
        public static Tuple<T1, T2, T3> Create<T1, T2, T3>(T1 t1, T2 t2, T3 t3)
        {
            return new Tuple<T1, T2, T3>(t1, t2, t3);
        }

        /// <summary>
        /// 4要素のタプルを生成します。
        /// </summary>
        public static Tuple<T1, T2, T3, T4> Create<T1, T2, T3, T4>(T1 t1, T2 t2, T3 t3, T4 t4)
        {
            return new Tuple<T1, T2, T3, T4>(t1, t2, t3, t4);
        }

        /// <summary>
        /// 5要素のタプルを生成します。
        /// </summary>
        public static Tuple<T1, T2, T3, T4, T5> Create<T1, T2, T3, T4, T5>(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5)
        {
            return new Tuple<T1, T2, T3, T4, T5>(t1, t2, t3, t4, t5);
        }
    }

    public struct Tuple<T1, T2>
    {
        public readonly T1 _1;
        public readonly T2 _2;

        internal Tuple(T1 t1, T2 t2)
        {
            _1 = t1;
            _2 = t2;
        }

        public override bool Equals(object obj)
        {
            if (obj is Tuple<T1, T2>)
            {
                var o = (Tuple<T1, T2>)obj;
                return Equals(_1, o._1) && Equals(_2, o._2);
            }
            
            return false;
        }

        public override int GetHashCode()
        {
            var result = 31;
            result ^= _1 == null ? 0 : _1.GetHashCode();
            result ^= _2 == null ? 0 : _2.GetHashCode();

            return result;
        }

        public static bool operator ==(Tuple<T1, T2> a, Tuple<T1, T2> b)
        {
            if (a == null)
            {
                return (b == null);
            }

            return a.Equals(b);
        }

        public static bool operator !=(Tuple<T1, T2> a, Tuple<T1, T2> b)
        {
            if (a == null)
            {
                return (b != null);
            }

            return (a.Equals(b) == false);
        }

        public override string ToString()
        {
            return string.Format("({0}, {1})", _1, _2);
        }
    }

    public struct Tuple<T1, T2, T3>
    {
        public readonly T1 _1;
        public readonly T2 _2;
        public readonly T3 _3;

        internal Tuple(T1 t1, T2 t2, T3 t3)
        {
            _1 = t1;
            _2 = t2;
            _3 = t3;
        }

        public override bool Equals(object obj)
        {
            if (obj is Tuple<T1, T2, T3>)
            {
                var o = (Tuple<T1, T2, T3>)obj;
                return Equals(_1, o._1) && Equals(_2, o._2) && Equals(_3, o._3);
            }
            
            return false;
        }

        public override int GetHashCode()
        {
            var result = 31;
            result ^= _1 == null ? 0 : _1.GetHashCode();
            result ^= _2 == null ? 0 : _2.GetHashCode();
            result ^= _3 == null ? 0 : _3.GetHashCode();


            return result;
        }

        public static bool operator ==(Tuple<T1, T2, T3> a, Tuple<T1, T2, T3> b)
        {
            if (a == null)
            {
                return (b == null);
            }

            return a.Equals(b);
        }

        public static bool operator !=(Tuple<T1, T2, T3> a, Tuple<T1, T2, T3> b)
        {
            if (a == null)
            {
                return (b != null);
            }

            return (a.Equals(b) == false);
        }

        public override string ToString()
        {
            return string.Format("({0}, {1}, {2})", _1, _2, _3);
        }
    }

    public struct Tuple<T1, T2, T3, T4>
    {
        public readonly T1 _1;
        public readonly T2 _2;
        public readonly T3 _3;
        public readonly T4 _4;

        internal Tuple(T1 t1, T2 t2, T3 t3, T4 t4)
        {
            _1 = t1;
            _2 = t2;
            _3 = t3;
            _4 = t4;
        }

        public override bool Equals(object obj)
        {
            if (obj is Tuple<T1, T2, T3, T4>)
            {
                var o = (Tuple<T1, T2, T3, T4>)obj;
                return Equals(_1, o._1) && Equals(_2, o._2) && Equals(_3, o._3) && Equals(_4, o._4);
            }

            return false;
        }

        public override int GetHashCode()
        {
            var result = 31;
            result ^= _1 == null ? 0 : _1.GetHashCode();
            result ^= _2 == null ? 0 : _2.GetHashCode();
            result ^= _3 == null ? 0 : _3.GetHashCode();
            result ^= _4 == null ? 0 : _4.GetHashCode();

            return result;
        }

        public static bool operator ==(Tuple<T1, T2, T3, T4> a, Tuple<T1, T2, T3, T4> b)
        {
            if (a == null)
            {
                return (b == null);
            }

            return a.Equals(b);
        }

        public static bool operator !=(Tuple<T1, T2, T3, T4> a, Tuple<T1, T2, T3, T4> b)
        {
            if (a == null)
            {
                return (b != null);
            }

            return (a.Equals(b) == false);
        }

        public override string ToString()
        {
            return string.Format("({0}, {1}, {2}, {3})", _1, _2, _3, _4);
        }
    }

    public struct Tuple<T1, T2, T3, T4, T5>
    {
        public readonly T1 _1;
        public readonly T2 _2;
        public readonly T3 _3;
        public readonly T4 _4;
        public readonly T5 _5;

        internal Tuple(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5)
        {
            _1 = t1;
            _2 = t2;
            _3 = t3;
            _4 = t4;
            _5 = t5;
        }

        public bool Equals(Tuple<T1, T2, T3, T4, T5> other)
        {
            return Equals(_1, other._1) && Equals(_2, other._2) && Equals(_3, other._3) && Equals(_4, other._4) && Equals(_5, other._5);
        }

        public override bool Equals(object obj)
        {
            if (obj is Tuple<T1, T2, T3, T4, T5>)
            {
                var o = (Tuple<T1, T2, T3, T4, T5>)obj;
                return Equals(_1, o._1) && Equals(_2, o._2) && Equals(_3, o._3) && Equals(_4, o._4) && Equals(_5, o._5);
            }

            return false;
        }

        public override int GetHashCode()
        {
            var result = 31;
            result ^= _1 == null ? 0 : _1.GetHashCode();
            result ^= _2 == null ? 0 : _2.GetHashCode();
            result ^= _3 == null ? 0 : _3.GetHashCode();
            result ^= _4 == null ? 0 : _4.GetHashCode();
            result ^= _5 == null ? 0 : _5.GetHashCode();

            return result;
        }

        public static bool operator ==(Tuple<T1, T2, T3, T4, T5> a, Tuple<T1, T2, T3, T4, T5> b)
        {
            if (a == null)
            {
                return (b == null);
            }

            return a.Equals(b);
        }

        public static bool operator !=(Tuple<T1, T2, T3, T4, T5> a, Tuple<T1, T2, T3, T4, T5> b)
        {
            if (a == null)
            {
                return (b != null);
            }

            return a.Equals(b) == false;
        }

        public override string ToString()
        {
            return string.Format("({0}, {1}, {2}, {3}, {4})", _1, _2, _3, _4, _5);
        }
    }
}
